/* ȡTGAͼļ,֧8,15,16,24λɫ */
#include <errno.h>
#include <string.h>
#include "gl.h"

typedef struct TGAHEADER{
	BYTE identsize;
	BYTE colormaptype;
	BYTE imagetype;
	WORD colormapstart;
	WORD colormaplength;
	BYTE colormapbits;
	WORD xstart, ystart;
	WORD width, height;
	BYTE bitsperpixel;
	BYTE descriptor;
} TGAHEADER;

static PixelInfo *pixelInfo;

static int ReadHeader( TGAHEADER *tgaheader, File *fp )
{
	tgaheader->identsize = fp->Getc();
	tgaheader->colormaptype = fp->Getc();
	tgaheader->imagetype = fp->Getc();
	tgaheader->colormapstart = fp->Getw();
	tgaheader->colormaplength = fp->Getw();
	tgaheader->colormapbits = fp->Getc();
	tgaheader->xstart = fp->Getw();
	tgaheader->ystart = fp->Getw();
	tgaheader->width = fp->Getw();
	tgaheader->height = fp->Getw();
	tgaheader->bitsperpixel = fp->Getc();
	tgaheader->descriptor = fp->Getc();

	if( tgaheader->colormapstart + tgaheader->colormaplength >= 256 )
		return -1;
	return 0;
}

static void ReadPalette( Palette *pal, int start, int length, File *fp )
{
	for( int i=start; i<start+length; i++ ){
		pal->palette[i].rgb = 0;
		pal->palette[i].rgbRed = fp->Getc();
		pal->palette[i].rgbGreen = fp->Getc();
		pal->palette[i].rgbBlue = fp->Getc();
	}
	pal->Convert();
}

static void ReadRleTga8( char *bmp, int width, File *fp )
{
	BYTE val;
	int count;
	
	do{
		count = fp->Getc();
		if( count & 0x80 ){
			count = ( count & 0x7f ) + 1;
			width -= count;
			val = fp->Getc();
			while( count -- )
				*( bmp ++ ) = val;
		}
		else{
			count ++;
			width -= count;
			fp->Read( bmp, count );
			bmp += count;
		}
	} while( width );
}

// load 15bit color mode file
static void ReadRleTga16( char *bmp, int width, File *fp )
{
	WORD val;
	WORD color;
	int count;

	do{
		count = fp->Getc();
		if( count & 0x80 ){
			count = ( count & 0x7f ) + 1;
			width -= count;
			val = fp->Getw();
			color = ((( val >> 10 ) & 0x1f ) << pixelInfo->redPos )
				| ((( val >> 5 ) & 0x1f ) << (pixelInfo->redPos - pixelInfo->greenPos))
				| ( val & 0x1f );
			while( count-- )
				*((short*) bmp++ ) = color;
		}
		else{
			count ++;
			width -= count;
			while( count-- ){
				val = fp->Getw();
				color = ((( val >> 10 ) & 0x1f ) << pixelInfo->redPos )
					| ((( val >> 5 ) & 0x1f ) << (pixelInfo->redPos - pixelInfo->greenPos))
					| ( val & 0x1f );
				*((short*) bmp ++ ) = color;
			}
		}
	} while( width );
}

static void ReadRleTga24( char *bmp, int width, File *fp )
{
	BYTE value[4];
	int count;

	do{
		count = fp->Getc();
		if( count & 0x80 ){
			count = ( count & 0x7f ) + 1;
			width -= count;
			fp->Read( value, 3 );
			while( count -- ){
				bmp[2] = value[2];
				bmp[1] = value[1];
				bmp[0] = value[0];
				bmp += 3;
			}
		}
		else{
			count ++;
			width -= count;
			while( count -- ){
				fp->Read( value, 3 );
				bmp[2] = value[2];
				bmp[1] = value[1];
				bmp[0] = value[0];
				bmp += 3;
			}
		}
	} while( width );
}

Bitmap* LoadTga( char *filename, Palette *pal )
{
	int compressed, y, yc, i;
	Bitmap *bmp;
	BYTE rgb[3];
	Palette paltemp;
	TGAHEADER tgaheader;
	WORD w, *s;
	File *fp;

	errno = 0;
	if( ( fp = cfile.Open( filename )) == NULL )
		return NULL;

	if( ReadHeader( &tgaheader, fp ) != 0 ){
		fp->Close();
		return NULL;
	}
	compressed = tgaheader.imagetype & 8;
	tgaheader.imagetype &= 7;
	if( tgaheader.imagetype < 1 || tgaheader.imagetype > 3 ){
		fp->Close();
		return NULL;
	}
	fp->Seek( tgaheader.identsize, SEEK_CUR );
	if( tgaheader.colormaplength != 0 ){
		if( pal != NULL ){
			ReadPalette( &paltemp, tgaheader.colormapstart, tgaheader.colormaplength, fp );
		}
		else
			fp->Seek( tgaheader.colormaplength * 3, SEEK_CUR );
	}
	
	switch( tgaheader.imagetype ){
	case 1:
		if( tgaheader.colormaptype != 1 || tgaheader.bitsperpixel != 8 ){
			fp->Close();
			return NULL;
		}
		if( pal != NULL )
			memcpy( (long*)pal, (long*)&paltemp, 256 );
		break;
	case 2:
	 /* truecolor image */
		if( ( tgaheader.colormaptype == 0 ) && (( tgaheader.bitsperpixel == 15 ) 
			|| ( tgaheader.bitsperpixel == 16 ) 
			|| ( tgaheader.bitsperpixel == 24 )) )
			break;
		else{
			fp->Close();
			return NULL;
		}

		break;
	case 3:
	 /* grayscale image */
		if(( tgaheader.colormaptype !=0 ) || ( tgaheader.bitsperpixel != 8 )){
			fp->Close();
			return NULL;
		}
		break;
	}

/*	if( tgaheader.bitsperpixel == 15 || tgaheader.bitsperpixel == 16 ){
		if( screenInfo.colorDepth == 16 )
			pixelInfo = &pixelInfo16;
		else if( screenInfo.colorDepth == 15 )
			pixelInfo = &pixelInfo15;	// photoshop is shit !!!!!
		//tgaheader.bitsperpixel = (BYTE)screenInfo.colorDepth;
	}
*/
	if( tgaheader.bitsperpixel == 16 )
		tgaheader.bitsperpixel = 15;
	if( tgaheader.bitsperpixel == 15 )
		pixelInfo = &pixelInfo15;	

	bmp = CreateBitmapEx( tgaheader.width, tgaheader.height, tgaheader.bitsperpixel );
	if( bmp == NULL ){
		fp->Close();
		return NULL;
	}
	if( tgaheader.bitsperpixel == 8 )
		(( Bitmap8* )bmp )->palette = pal;

	for( y = tgaheader.height; y!=0; y-- ){
		yc = ( tgaheader.descriptor & 0x20 ) ? tgaheader.height - y : y - 1;
		switch( tgaheader.imagetype ){
		case 1:
		case 3:
			if( compressed )
				ReadRleTga8( bmp->line[yc], tgaheader.width, fp );
			else
				fp->Read( bmp->line[yc], tgaheader.width );
			break;

		case 2:
			if( tgaheader.bitsperpixel == 24 ){
				if( compressed ){
					ReadRleTga24( bmp->line[yc], tgaheader.width, fp );
				}
				else{
					//printf( "%d\n", pixelInfo->redPos/8 );

					for( i=0; i<tgaheader.width; i++ ){
						fp->Read( rgb, 3 );
						bmp->line[yc][ i*3 + 2 ] = rgb[2];
						bmp->line[yc][ i*3 + 1 ] = rgb[1];
						bmp->line[yc][ i*3 + 0 ] = rgb[0];
					}
				}
			}
			else{
				if( compressed ){
					ReadRleTga16( bmp->line[yc], tgaheader.width, fp );
				}
				else{
					s = ( WORD* )( bmp->line[yc] );
					for( i=0; i<tgaheader.width; i++ ){
						w = fp->Getw();
						s[ i ] = ((( w >> 10 ) & 0x1f ) << pixelInfo->redPos )
							| ((( w >> 5) & 0x1f ) << (pixelInfo->redPos - pixelInfo->greenPos ))
							| ( w & 0x1f );
					}
				}
			}
			break;
		} // end of switch
	} // end of for
	
	fp->Close();
	if( errno ){
		delete bmp;
		return NULL;
	}
	return bmp;
}

int SaveTga( char *filename, Bitmap *bmp )
{
	FILE *fp;
	int depth, x, y, temp;

	errno = 0;

	if( ( fp = fopen( filename, "wb" )) == NULL )
		return errno;

	depth = bmp->colorDepth;
	if( depth == 15 )
		depth = 16;
	else if( depth == 32 )
		depth = 24;
/*	BYTE identsize;
	BYTE colormaptype;
	BYTE imagetype;
	WORD colormapstart;
	WORD colormaplength;
	BYTE colormapbits;
	WORD xstart, ystart;
	WORD width, height;
	BYTE bitsperpixel;
	BYTE descriptor;
*/
	fputc( 0, fp );
	fputc( (depth == 8 ) ? 1 : 0, fp );
	fputc( (depth == 8 ) ? 1 : 2, fp );
	temp = 0;
	fwrite( &temp, 1, 2, fp );
	temp = ( depth == 8 ) ? 256 : 0;
	fwrite( &temp, 1, 2, fp );
	temp = ( depth == 8 ) ? 24 : 0;
	fputc( temp, fp );
	temp = 0;
	fwrite( &temp, 2, 2, fp );
	fwrite( &(bmp->width), 2, 1, fp );
	fwrite( &(bmp->height), 2, 1, fp );
	fputc( depth, fp );
	fputc( 1, fp );
	if( depth == 8 ){
	}

	switch( bmp->colorDepth ){

	case 8:
		for( y = bmp->height-1; y>=0; y-- )
			for( x=0; x<bmp->width; x++ )
				fputc( bmp->GetPixel( x, y ), fp );
	break;

	case 15:
		for( y = bmp->height-1; y>=0; y-- )
			for( x=0; x<bmp->width; x++ ){
				temp = bmp->GetPixel( x, y );
				fwrite( &temp, 2, 1, fp );
			}
	break;

	case 16:
		for( y = bmp->height-1; y>=0; y-- )
			for( x=0; x<bmp->width; x++ ){
				temp = bmp->GetPixel( x, y );
				fwrite( &temp, 2, 1, fp );
			}
	break;

	case 24:
		for( y = bmp->height-1; y>=0; y-- )
			for( x=0; x<bmp->width; x++ ){
				temp = bmp->GetPixel( x, y );
				fwrite( &temp, 3, 1, fp );
			}
	break;

	case 32:
		for( y = bmp->height-1; y>=0; y-- )
			for( x=0; x<bmp->width; x++ ){
				temp = bmp->GetPixel( x, y );
				fwrite( &temp, 3, 1, fp );
			}
	break;
	}

	fclose( fp );
	return errno;
}
